/***********************************************************************
*
* darts uwindow.c -- Version 3.0
*
* Copyright (c)
* Apple Computer, Inc.  1986-1990
* All Rights Reserved.
*
* Developer Technical Support Apple II Sample Code
*
* This file contains the code which implements
* windows in the program.
*
***********************************************************************/

#include <types.h>
#include <control.h>
#include <intmath.h>
#include <list.h>
#include <memory.h>
#include <resources.h>
#include <window.h>
#include "darts.h"

extern GrafPortPtr		theWindow;
extern unsigned int 	firstUpdateComplete, gameType, weHaveAWinner, userID;
extern unsigned int 	crickettTables[NumPlayers][26], score[NumPlayers];
extern unsigned int 	listEntries[NumPlayers];
extern char 			*scoreStringArray[NumPlayers];
extern char 			scoreStrings[NumPlayers][64];
extern MyMemRecHndl 	scoreList[NumPlayers];

extern char 	test[80];



/***********************************************************************
*
* invalScore
*
* Invalidates a rectangle that holds the score for player one or two
* so that it will be updated.
*
***********************************************************************/
void			invalScore (playerNum)
unsigned int	playerNum;
{
	CtlRecHndl		tempHndl;
	unsigned long	id;
	GrafPortPtr 	keepPort;

	id = 0x60000L;
	if (!playerNum) id = 0x50000L;

	tempHndl = GetCtlHandleFromID(theWindow, id);

	keepPort = GetPort();
	SetPort(theWindow);
	InvalRect(&(*tempHndl)->ctlRect);
	SetPort(keepPort);
}



void			int2pstr(val, str)
unsigned int	val;
char			*str;
{
	unsigned int	j, k;

	Int2Dec(val, str + 1, k = 6, 0);

	while (str[1] == 32) {
		for (j = 1; j < k; j++) str[j] = str[j + 1];
		k--;
	}
	*str = k;
}



/***********************************************************************
*
* drawThisWindow
*
* Draws the window whose port is the current port.
*
***********************************************************************/
void	drawThisWindow()
{
	unsigned int	dbreg, i;
	Rect			tempRect;

	dbreg = SaveDB();

	firstUpdateComplete = 1;

	if (!gameType) {
		GetPortRect(&tempRect);
		tempRect.h1 += ((tempRect.h2 - tempRect.h1) >> 1);
		tempRect.h2 = tempRect.h1 + 2;
		tempRect.v1 += 15;
		tempRect.v2 -= 18;
		PaintRect(&tempRect);
	}

	for (i = 0; i < NumPlayers; i++) {
		int2pstr(score[i], scoreStrings[i]);
	}

	SetCtlParamPtr(scoreStringArray);

	DrawControls(theWindow);
	RestoreDB(dbreg);
}



/***********************************************************************
*
* drawListItem
*
* Draws the indicated list item.
*
***********************************************************************/
pascal void 	drawListItem(rptr, memRecPtr, listCtl)
Rect			*rptr;
MyMemRecPtr 	memRecPtr;
Handle			listCtl;
{
	unsigned int	dbreg, theScore, selected, mode;
	char			str[10], *cptr;

	dbreg = SaveDB();

	theScore = (int)memRecPtr->memPtr;
	selected = ((memRecPtr->memFlag & 0xC0) == 0x80);

	mode = GetPenMode();
	if (!selected) SetPenMode(0x8000);
	PaintRect(rptr);
	SetPenMode(mode);

	int2pstr(theScore, cptr = str); 	/* Assigning cptr to str saves code due to
										** the below reference to cptr.
										*/

	MoveTo(rptr->h1 + 4, rptr->v2 - 1);

	mode = GetTextMode();
	SetTextMode(0x8002);
	DrawString(cptr);
	SetTextMode(mode);

	RestoreDB(dbreg);
}



/***********************************************************************
*
* addToList
*
* Adds the indicated score to the right list.
*
***********************************************************************/
void			addToList(playerNum, amount)
unsigned int	playerNum, amount;
{
	unsigned int	topOfList;
	ListCtlRecHndl	theHndl;
	MyMemRecPtr 	memRecPtr;
	unsigned long	size, id;

	listEntries[playerNum]++;
	topOfList = listEntries[playerNum] - 3;
	if ((!topOfList) || (topOfList & 0x8000)) topOfList = 1;

	if (
		(size = listEntries[playerNum] * sizeof(MyMemRec)) >=
		GetHandleSize(scoreList[playerNum])
	) {
		SetHandleSize(size + 100, scoreList[playerNum]);
	}

	memRecPtr = (*scoreList[playerNum]) + (listEntries[playerNum] - 1);
	memRecPtr->memPtr = (char *)amount;
	memRecPtr->memFlag = 0;
	
	id = 0x40000L;
	if (!playerNum) id = 0x30000L;
	theHndl = GetCtlHandleFromID(theWindow, id);

	NewList2(
		drawListItem,							/* drawing routine addr */
		topOfList,								/* First Item to display */
		scoreList[playerNum],					/* ref to mem rec array */
		refIsHandle,							/* List type */
		listEntries[playerNum], 				/* Num Items */
		theHndl 								/* List ctl handle */
	);
}



/*****************************************************************************
*
* fixButtonTitle
*
* This routine is called only when the chosen game is crickett.  Its job
* is to adjust the button title of the button associated with the amount
* passed.
*
* There are four possible states of the button title.  Which state it is
* in depends on the number times it has been pressed (contained in the
* CrickettTables).
*
*****************************************************************************/
void			fixButtonTitle(playerNum, amount)
unsigned int	playerNum, amount;
{
	CtlRecHndl		theHndl;
	unsigned int	num;
	long			theID;
	char			*cptr;

	if (playerNum == Player1) theID = amount;
	else theID = amount | 0x8000;

	theHndl = GetCtlHandleFromID(theWindow, theID);
	switch(num = crickettTables[playerNum][amount]) {
		case 0:
			cptr = "\p ";
			break;
		case 1:
			cptr = "\p/";
			break;
		case 2:
			cptr = "\pX";
			break;
		case 3:
			cptr = "\p*";
			break;
	}
	if (num < 4) SetCtlTitle(cptr, theHndl);
}	



/***********************************************************************
*
* removeSelected
*
* Removes any selected scores from the list.
*
***********************************************************************/
void			removeSelected(playerNum)
unsigned int	playerNum;
{
	unsigned int	itemToRemove, amount, topOfList;
	ListCtlRecHndl	theHndl;
	MyMemRecPtr 	memRecPtr;
	unsigned long	id, size;

	id = 0x40000L;
	if (!playerNum) id = 0x30000L;
	theHndl = GetCtlHandleFromID(theWindow, id);

	for (;;) {
		itemToRemove = NextMember2(0, theHndl);
		if (itemToRemove) {
			amount = (unsigned int)(*scoreList[playerNum])[itemToRemove - 1].memPtr;
			if (!gameType) score[playerNum] -= amount;
			else {
				if (crickettTables[playerNum][amount] > 3) {
					score[playerNum] -= amount;
				}
				crickettTables[playerNum][amount]--;
				fixButtonTitle(playerNum, amount);
			}

			memRecPtr = (*scoreList[playerNum]) + (itemToRemove - 1);
			size = (listEntries[playerNum] - itemToRemove) * sizeof(MyMemRec);
			BlockMove(memRecPtr + 1, memRecPtr, size);

			listEntries[playerNum]--;
			topOfList = GetCtlValue(theHndl) - 1;
			if (!topOfList) topOfList++;

			NewList2(
				drawListItem,							/* drawing routine addr */
				topOfList,								/* First Item to display */
				scoreList[playerNum],					/* ref to mem rec array */
				refIsHandle,							/* List type */
				listEntries[playerNum], 				/* Num Items */
				theHndl 								/* List ctl handle */
			);
		}
		else break;
	}
	invalScore(playerNum);
}



/***********************************************************************
*
* clearList
*
* Clears the indicated list.
*
***********************************************************************/
void			clearList(playerNum)
unsigned int	playerNum;
{
	ListCtlRecHndl	theHndl;
	unsigned long	id;

	id = 0x30000L;
	if (!playerNum) id = 0x40000L;
	theHndl = GetCtlHandleFromID(theWindow, id);

	listEntries[playerNum] = 0;
	NewList2(
		drawListItem,							/* drawing routine addr */
		0,										/* Item to display */
		scoreList[playerNum],					/* ref to mem rec array */
		refIsHandle,							/* List type */
		0,										/* Num Items */
		theHndl 								/* List ctl handle */
	);
}



/***********************************************************************************
*
* startUpRobinGame
*
* Opens the robin game window and zeros the scores.
*
***********************************************************************************/
void	startupRobinGame()
{
	theWindow = NewWindow2
		(NULL, NULL, drawThisWindow, NULL, refIsResource, RobinWindow, rWindParam1);

	listEntries[Player1] = listEntries[Player2] = 0;
}



/************************************************************************************
*
* startupCrickettGame
*
* Opens the crickett game window and zeros the scores.
*
************************************************************************************/
void	startupCrickettGame()
{
	theWindow = NewWindow2
		(NULL, 1L, drawThisWindow, NULL, refIsResource, CrickettWindow, rWindParam1);

	listEntries[Player1] = listEntries[Player2] = weHaveAWinner = 0;
}



/***********************************************************************
*
* setupWindows
*
* Inits any of the window unit variables we need to start up
* the game.  Calls the routine that opens the first window.
*
***********************************************************************/
void	setupWindows()
{
	unsigned int	i;

	firstUpdateComplete = 0;
	for (i = 0; i < NumPlayers; i++) {
		scoreList[i] =
			(MyMemRecHndl)NewHandle(sizeof(MyMemRec) * 100L, userID, 0, NULL);
	}
	listEntries[Player1] = listEntries[Player2] = 0;

	startupRobinGame();
}
